unit GistogramService03;

interface
  uses
  //  
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, jpeg, ExtCtrls, Math,
  ToolWin, ImgList, Buttons,
  //    Image Tools
  MainData,
  //   
  EngineMainData01, EngineImgService01, GraphXYv3,
  //   
  GistogramMainData01;

// ========================================================================
//        TWHSelector
//           
// ========================================================================
//        
type TOnRulMove = procedure (Sender : TObject; Row, Col : integer) of object;

//       
type TOnChoice = procedure (Sender : TObject; Row, Col : integer) of object;

//        
type TOnRulBegin = procedure (Sender : TObject) of object;

type TWHSelector = class(TObject)
    private
       fImg       : TImage;   //  Image
       fSavPen    : record    //    Pen
                      Mode  : TPenMode;
                      Style : TPenStyle;
                      Color : TColor;
                    end;
       fMaxH      : integer;  //   
       fMaxW      : integer;  //   
       fCClear    : TColor;   //   Image
       fCRuler    : TColor;   //   
       fRulOn     : boolean;  //  -  
       fRulMov    : boolean;  //  -   ( )
       fXRuler    : integer;  //  X -  
       fYRuler    : integer;  //  Y -  
       fChoiceOn  : boolean;  //  -   ( )
       fXChoice   : integer;  // X -  
       fYChoice   : integer;  // Y -  
       //   TWHSelector   
       fOnRulMove  : TOnRulMove;
       fOnChoice   : TOnChoice;
       fOnRulBegin : TOnRulBegin;
       // --------------------------------------
       //  
       procedure fImgMouseDown(Sender: TObject;
                 Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
       procedure fImgMouseMove(Sender: TObject;
                 Shift: TShiftState; X, Y: Integer);
       // --------------------------------------
       //      
       procedure SetRulMode();
       //   
       procedure SavePen();
       //   
       procedure RestorePen();
       // --------------------------------------
    public
       // --------------------------------------
       //   
       constructor Create(RqImg : TImage);
       //   
       procedure Free();
       //   Image 
       procedure ClearImage();
       //  
       procedure HideRulers();
       //  
       procedure ShowRulers();
       // --------------------------------------
       // 
       //  Image
       property Image : TImage  read fImg;
       //   
       property MaxH  : integer read fMaxH;
       //   
       property MaxW  : integer read fMaxW;
       //  
       property RulerColor : TColor read fCRuler write fCRuler;
       //  
       property ClearColor : TColor read fCClear write fCClear;
       //  -   X  Y
       property ChoiceOn   : boolean read fChoiceOn;
       //   X  -1;
       property XChoice    : integer read fXChoice;
       //   Y  -1;
       property YChoice    : integer read fYChoice;
       //    
       property onRulMove  : TOnRulMove  read fOnRulMove  write fOnRulMove;
       property onChoice   : TOnChoice   read fOnChoice   write fOnChoice;
       property onRulBegin : TOnRulBegin read fOnRulBegin write fOnRulBegin;
       // --------------------------------------
end;
// ========================================================================


//         
var WHSelector : TWHSelector;

// ------------------------------------------------------------------------
//          
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
//     ,
//     , 
//  
function PrepareAcExtract(RqRowOrCol : Char) : boolean;
// ------------------------------------------------------------------------
//     ,
//     
procedure CalcAndShowMDExtract(RqCannel : Char);
// ------------------------------------------------------------------------
//     
procedure Convolution (RqCnv : Char;
                       RqDE1 : extended;
                       RqFArr1, RqFArr2 : TArrExtnd;
                   var CnvArr : TArrExtnd);
// ------------------------------------------------------------------------
//      
// ------------------------------------------------------------------------
//      
function CalcFragME(RqCannel : Char) : extended;
// ------------------------------------------------------------------------
//     
function  CalcFragDE(RqCannel : Char; MECanel : extended) : extended;

// ========================================================================
// ========================================================================
implementation
// ========================================================================
// ========================================================================

// ========================================================================
//          TWHSelector
// ========================================================================
// ------------------------------------------------------------------------
// 05.04.2014
//   
constructor TWHSelector.Create(RqImg : TImage);
begin
    inherited Create;
    fImg := RqImg;
    //   Bitmap
    fImg.Picture.Bitmap.PixelFormat := pf24bit;
    fImg.Picture.Bitmap.Height := fImg.Height;
    fImg.Picture.Bitmap.Width  := fImg.Width;
    //     
    fMaxH   := fImg.Height;
    fMaxW   := fImg.Width;
    //   
    fCClear := clBtnFace;
    fCRuler := clBlack;
    ClearImage();
    //   
    fOnRulMove  := nil;
    fOnChoice   := nil;
    fOnRulBegin := nil;
    //    
    fXRuler := fImg.Width  div 2;
    fYRuler := fImg.Height div 2;
    //    
    fRulOn  := False;
    fRulMov := False;
    //     
    ShowRulers();
end;
// ------------------------------------------------------------------------
// 05.04.2014
//   
procedure TWHSelector.Free();
begin
    fImg.OnMouseDown := nil;
    fImg.OnMouseMove := nil;
    ClearImage();
    inherited Free;
end;
// ------------------------------------------------------------------------
// 05.04.2014
//      
procedure TWHSelector.SetRulMode();
begin
  with fImg.Canvas do
  begin
      Pen.Mode  := pmNotXOR;
      Pen.Color := fCRuler;
      Pen.Width := 1;
      Pen.Style := psDot;
  end;
end;
// ------------------------------------------------------------------------
// 05.04.2014
//   
procedure TWHSelector.SavePen();
begin
   fSavPen.Mode := fImg.Canvas.Pen.Mode;
   fSavPen.Style := fImg.Canvas.Pen.Style;
   fSavPen.Color := fImg.Canvas.Pen.Color;
end;
// ------------------------------------------------------------------------
// 05.04.2014
//   
procedure TWHSelector.RestorePen();
begin
   fImg.Canvas.Pen.Mode :=  fSavPen.Mode;
   fImg.Canvas.Pen.Style := fSavPen.Style;
   fImg.Canvas.Pen.Color := fSavPen.Color;
end;
// ------------------------------------------------------------------------
// 05.04.2014
//   Image 
procedure TWHSelector.ClearImage();
var WRect    : TRect;
begin
  with fImg.Canvas do
  begin
     //  
     SavePen();
     //  
     WRect := Rect(0, 0, fImg.Width, fImg.Height);
     Pen.Mode    := pmCopy;
     Pen.Style   := psSolid;
     Pen.Color   := fCClear;
     Brush.Color := fCClear;
     Brush.Style := bsSolid;
     // 
     Rectangle(WRect);
     //  
     RestorePen();
  end;
end;
// ------------------------------------------------------------------------
// 05.04.2014
//  
procedure TWHSelector.HideRulers();
begin
   // ,   
  if fRulOn = True
  then begin
    //   
    fImg.OnMouseMove := nil;
    fImg.OnMouseMove := nil;
    fRulMov   := False;
    //    
    SetRulMode();
    //  
    with fImg.Canvas do
    begin
      //   
      MoveTo (fXRuler, 0);
      LineTo (fXRuler, fImg.Height);
      //   
      MoveTo (0,          fYRuler);
      LineTo (fImg.Width, fYRuler);
    end;
  end;
  //  
  fRulOn := False;
  fChoiceOn := False;
end;
// ------------------------------------------------------------------------
// 05.04.2014
//  
procedure TWHSelector.ShowRulers();
begin
  // ,   
  if fRulOn = False
  then begin
    //    
    SetRulMode();
    //  
    with fImg.Canvas do
    begin
      //   
      MoveTo (fXRuler, 0);
      LineTo (fXRuler, fImg.Height);
      //   
      MoveTo (0,          fYRuler);
      LineTo (fImg.Width, fYRuler);
    end;
    //  
    fRulOn := True;
    //   
    fRulMov    := True;
    fImg.OnMouseMove := fImgMouseMove;
    fImg.OnMouseDown := fImgMouseDown;
  end;
end;
// ------------------------------------------------------------------------
// 05.04.2014
procedure TWHSelector.fImgMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if fRulMov
  then begin
     //  
     fImg.OnMouseMove := nil;
     fRulMov   := False;
     fXChoice  := X;
     fYChoice  := Y;
     fChoiceOn := True;
     if Assigned(fOnChoice) then fOnChoice(Self, fYRuler, fXRuler);
  end
  else begin
     //     
     fChoiceOn := False;
     fRulMov    := True;
     fImg.OnMouseMove := fImgMouseMove;
     fXChoice   := -1;
     fYChoice   := -1;
     if Assigned(fOnRulBegin) then fOnRulBegin(Self);
  end;
end;
// ------------------------------------------------------------------------
// 05.04.2014
//   
procedure TWHSelector.fImgMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
   with fImg.Canvas do
   begin
       //    
       MoveTo (fXRuler,           0);
       LineTo (fXRuler, fImg.Height);
       fXRuler := X;
       //    
       MoveTo (fXRuler,           0);
       LineTo (fXRuler, fImg.Height);
       //    
       MoveTo (0,          fYRuler);
       LineTo (fImg.Width, fYRuler);
       fYRuler := Y;
       //    
       MoveTo (0,          fYRuler);
       LineTo (fImg.Width, fYRuler);
       if Assigned(fOnRulMove) then fOnRulMove(Self, fYRuler, fXRuler);
   end;
end;
// ========================================================================
//          TWHSelector
// ========================================================================

// ========================================================================
//         UNIT
// ========================================================================
// ------------------------------------------------------------------------
// 06.04.2014
//    
procedure CalcDExtr(RqCannel : Char);
var LC  : extended;   //   
    Ind : integer;    //  
    WE1 : extended;   //  
begin
  //      
  with AcExtract
  do begin
    DE  := 0;         //   
    LC  := Sqrt(3);   //    Light
    //  
    if Length(SrcPntArr) < 2 then Exit;
    //   
    for Ind := Low(SrcPntArr) to High(SrcPntArr)
    do begin
       //   
       case RqCannel of
       'R' : DE := DE + (SrcPntArr[Ind].R - ME) * (SrcPntArr[Ind].R - ME);
       'G' : DE := DE + (SrcPntArr[Ind].G - ME) * (SrcPntArr[Ind].G - ME);
       'B' : DE := DE + (SrcPntArr[Ind].B - ME) * (SrcPntArr[Ind].B - ME);
       'L' : begin
                WE1 := SrcPntArr[Ind].R * SrcPntArr[Ind].R;
                WE1 := WE1 + SrcPntArr[Ind].G * SrcPntArr[Ind].G;
                WE1 := WE1 + SrcPntArr[Ind].B * SrcPntArr[Ind].B;
                //   LIGHT
                WE1 := Sqrt(WE1) / LC;
                DE  := DE + (WE1 - ME) * (WE1 - ME);
             end;
             else ME := 0;
       end;
    end;
    //     
    DE := DE / NumPnt;
    // ---------------------------------
    //  -  .    
    //   
    MDOk := TRUE;
    // ---------------------------------
  end; // of with
end;

// ------------------------------------------------------------------------
// 06.04.2014
//     
procedure CalcMExtr(RqCannel : Char);
var LC  : extended;   //   
    Ind : integer;    //  
    WE1 : extended;   //  
begin
  //      
  with AcExtract
  do begin
    LC  := Sqrt(3);   //    Light
    ME  := 0;         //   
    //  
    if Length(SrcPntArr) < 2 then Exit;
    //   
    for Ind := Low(SrcPntArr) to High(SrcPntArr)
    do begin
       case RqCannel of
       'R' : ME := ME + SrcPntArr[Ind].R;
       'G' : ME := ME + SrcPntArr[Ind].G;
       'B' : ME := ME + SrcPntArr[Ind].B;
       'L' : begin
                //   Light
                WE1 := SrcPntArr[Ind].R * SrcPntArr[Ind].R;
                WE1 := WE1 + SrcPntArr[Ind].G * SrcPntArr[Ind].G;
                WE1 := WE1 + SrcPntArr[Ind].B * SrcPntArr[Ind].B;
                //   LIGHT
                WE1 := Sqrt(WE1) / LC;
                ME := ME + WE1;
             end;
             else ME := 0;
       end;
    end;
    ME := ME / NumPnt;
  end; // of with
end;

// ------------------------------------------------------------------------
// 06.04.2014
//    
procedure ShowMExt(RqCannel : Char);
var LC  : extended;   //   
    Ind : integer;    //  
    WE1 : extended;   //  
begin
   //      
   with AcExtract
   do begin
     LC  := Sqrt(3);   //    Light
     for Ind := Low(SrcPntArr) to High(SrcPntArr)
     do begin
        case RqCannel of
       'R' : SrcPntArrCM[Ind] := (SrcPntArr[Ind].R - ME);
       'G' : SrcPntArrCM[Ind] := (SrcPntArr[Ind].G - ME);
       'B' : SrcPntArrCM[Ind] := (SrcPntArr[Ind].B - ME);
       'L' : begin
                //   Light
                WE1 := SrcPntArr[Ind].R * SrcPntArr[Ind].R;
                WE1 := WE1 + SrcPntArr[Ind].G * SrcPntArr[Ind].G;
                WE1 := WE1 + SrcPntArr[Ind].B * SrcPntArr[Ind].B;
                //   LIGHT
                WE1 := Sqrt(WE1) / LC;
                WE1 := (WE1 - ME);
                SrcPntArrCM[Ind] := WE1;
             end;
             else ME := 0;
        end;
        //     
        Graph1Arr[Ind].Y := SrcPntArrCM[Ind];
        Graph1Arr[Ind].X := Ind;
     end;
     //    
     GraphXY1.PicAxesX := '%3.0f';
     GraphXY1.PicAxesY := '%4.1f';
     GraphXY1.FullEraseAreaXY;
     GraphXY1.ShowGraphXY(Graph1Arr, clLime);
   end; // of with
end;
// ------------------------------------------------------------------------
// 06.04.2014
//     
function PrepareAcArray() : boolean;
begin
   Result := False;      //  
   // ------------------------------------
   with AcExtract
   do begin
      try
          // --------------------------
          //    
          SetLength(SrcPntArr, NumPnt);
          // --------------------------
          //     (   )
          SetLength(SrcPntArrCM, NumPnt);
          // --------------------------
          //     
          SetLength(FuncArr, NumPnt);
          // --------------------------
          //     
          //    Convolution
          // --------------------------
          //     
          SetLength(Graph1Arr, NumPnt);
          // --------------------------
          //     
          SetLength(Graph2Arr, NumPnt);
          // --------------------------
          //     
          SetLength(Graph3Arr, NumPnt);
          // --------------------------
          Result := True;  //  
      except
          MessageDlg('    ',
                     mtWarning, [mbOk], 0);
          //  
          SetLength(SrcPntArr, 0);
          SetLength(SrcPntArrCM, 0);
          SetLength(FuncArr, 0);
          SetLength(CnvlArr, 0);
          SetLength(Graph1Arr, 0);
          SetLength(Graph2Arr, 0);
          SetLength(Graph3Arr, 0);
      end;
  end;
end;
// ------------------------------------------------------------------------
// 06.04.2014
//     ,
//     , 
//  
function PrepareAcExtract(RqRowOrCol : Char) : boolean;
var  Ind : integer;      //  
begin
   Result := False;      //  
   // ------------------------------------
   //    1
   if not WHSelector.fChoiceOn
   then begin
       MessageDlg('  '
                 + #13#10
                 +'(   )',
                   mtWarning, [mbOk], 0);
                  Exit;
   end;
   with AcExtract
   do begin
      // ---------------------------------
      //  -  .    
      //    TRUE   
      // ,  CalcDExtr
      MDOk := FALSE;
      // ---------------------------------
      //    2
      if (Length(TabColorFrag)     < 2) or
         ((Length(TabColorFrag[0]) < 2))
      then begin
              MessageDlg(' '
                        + #13#10
                        + '  ',
                          mtWarning, [mbOk], 0);
              Exit;      //  
      end;
      //    3
      if  ((ChoiceRow < Low (TabColorFrag)) or
           (ChoiceRow > High(TabColorFrag))) and (IdRowCol = 'R')
      then begin
              //   
              ChoiceRow := -1;
              MessageDlg('  '
                        + #13#10
                        +' ',
                          mtWarning, [mbOk], 0);
              Exit;      //  
      end;
      //    4
      if  ((ChoiceCol < Low (TabColorFrag[0])) or
           (ChoiceCol > High(TabColorFrag[0]))) and (IdRowCol = 'C')
      then begin
              //   
              ChoiceCol := -1;
              MessageDlg('  '
                       + #13#10
                       + ' ',
                          mtWarning, [mbOk], 0);
              Exit;      //  
      end;
      // ---------------------------------
      //    
      //     
     case RqRowOrCol of
     'R' : begin
              //       
              NumPnt := Length(TabColorFrag[ChoiceRow]);
              //     
              Result := PrepareAcArray();
              if not Result then Exit;
              //      
              for Ind := Low(SrcPntArr) to High(SrcPntArr)
              do SrcPntArr[Ind] := TabColorFrag[ChoiceRow, Ind];
           end;
     'C' : begin
               //       
               NumPnt := Length(TabColorFrag);
               //     
               Result := PrepareAcArray();
               if not Result then Exit;
               //      
               for Ind := Low(SrcPntArr) to High(SrcPntArr)
               do SrcPntArr[Ind] := TabColorFrag[Ind, ChoiceCol];
           end;
     end;
     Result := True;      //  
   end; // of with
end;
// ------------------------------------------------------------------------
// 06.04.2014
//     ,
//     
procedure CalcAndShowMDExtract(RqCannel : Char);
begin
   //     
   CalcMExtr(RqCannel);
   //    
   CalcDExtr(RqCannel);
   //    
   ShowMExt(RqCannel);
end;

// ------------------------------------------------------------------------
// 12.04.2014
//    
function AutoCor(RqCnv : Char;
                 RqDE1 : extended;
                 RqArr1, RqArr2 : TArrExtnd;
                 Ind1, Ind2, Len : integer) : double;
var Ind : integer;
begin
   Result := 0;
   for Ind := 0 to Abs(Len -1)
   do begin
     //  
     if Ind + Ind1 > High (RqArr1) then Exit;
     //  
     if Ind + Ind2 > High (RqArr1) then Exit;
     // 
     Result := Result +  RqArr1[Ind + Ind1] * RqArr2[Ind + Ind2];
   end;
   if (RqCnv = 'A') and (RqDE1 > 0) then Result := Result / RqDE1;


end;
// ------------------------------------------------------------------------
// 12.04.2014
//  
procedure Convolution (RqCnv : Char;
                       RqDE1 : extended;
                       RqFArr1, RqFArr2 : TArrExtnd;
                   var CnvArr : TArrExtnd);
var NumPnt,  //     
    MaxInd, TauB, TauE, Tau, Ind1, Ind2, Len, IndW : integer;
begin

  Ind1 := 0; Ind2 := 0; Len := 0;
  //    1
  if (Length(RqFArr1) < 2) or (Length(RqFArr2) < 2)
  then begin
     ShowMessage ('      ');
     Exit;
  end;
  //    2
  if Length(RqFArr1) <> Length(RqFArr2)
  then begin
     ShowMessage ('      ');
     Exit;
  end;

  //    
  NumPnt := Length(RqFArr1);
  MaxInd := NumPnt - 1;
  SetLength(CnvArr, ((2 * NumPnt) -1) + (2 * CnvAddPnt));
  for IndW := Low(CnvArr) to High(CnvArr) do CnvArr[IndW] := 0;

  //   
  IndW := 0;
  TauB := - MaxInd;
  TauE :=   MaxInd;
  Tau  := TauB;

  //  
  repeat
     // ---------------------------------------------
     //      
     if Tau < 0
     then begin
        Ind1 := 0;            //     1
        Ind2 := -Tau;         //     2
        Len := NumPnt + Tau;  //  
      end;
      if Tau = 0
      then begin
        Ind1 := 0; Ind2 := 0;
        Len  := NumPnt;
      end;
      if Tau > 0
      then begin
        Ind1 := Tau; Ind2 := 0;
        Len := NumPnt - Tau;
      end;
     // ---------------------------------------------
     //     
     case RqCnv of
    'A' : CnvArr[IndW + CnvAddPnt] := AutoCor(RqCnv, RqDE1,
                                              RqFArr1, RqFArr1,
                                              Ind1, Ind2, Len);
    'C' : CnvArr[IndW + CnvAddPnt] := AutoCor(RqCnv, RqDE1,
                                              RqFArr1, RqFArr2,
                                              Ind1, Ind2, Len);
     end;
     // ---------------------------------------------
     Inc(IndW);
     Inc(Tau);
  until (Tau > TauE);
end;

// ========================================================================
//        
// ========================================================================
// ------------------------------------------------------------------------
// 24.04.2014
//     
function  CalcFragDE(RqCannel : Char; MECanel : extended) : extended;
var LC  : extended;    //   
    Num : integer;     //     
    Row : integer;     //  
    Col : integer;     //  
    DE  : extended;    //  
    WE  : extended;    //  
begin
    LC     := Sqrt(3);       //    Light
    Num    := 0;  DE := 0;   //  
    Result := 0;             //   
    //  
    if Length(TabColorFrag) < 1 then Exit;
    //   
    for Row := Low(TabColorFrag) to High(TabColorFrag)
    do begin
       for Col := Low(TabColorFrag[Row]) to High(TabColorFrag[Row])
       do begin
           with TabColorFrag[Row,Col]
           do begin
               //   
             case RqCannel of
               'R' : DE := DE + (R - MECanel) * (R - MECanel);
               'G' : DE := DE + (G - MECanel) * (G - MECanel);
               'B' : DE := DE + (B - MECanel) * (B - MECanel);
               'L' : begin
                       //   LIGHT
                       WE := Sqrt(R * R + G * G + B * B) / LC;
                       DE  := DE + (WE - MECanel) * (WE - MECanel);
                     end;
               else DE := 0;
             end;
           end;
           Num := Num + 1;
       end;
    end;
    //   
    Result := DE / Num;
end;

// ------------------------------------------------------------------------
// 24.04.2014
//      
function CalcFragME(RqCannel : Char) : extended;
var LC  : extended;    //   
    Num : integer;     //     
    Row : integer;     //  
    Col : integer;     //  
    ME  : extended;    //  
    WE  : extended;    //  
begin
    LC     := Sqrt(3);       //    Light
    Num    := 0;  ME := 0;   //  
    Result := 0;             //   
    //  
    if Length(TabColorFrag) < 1 then Exit;
    //   
    for Row := Low(TabColorFrag) to High(TabColorFrag)
    do begin
       for Col := Low(TabColorFrag[Row]) to High(TabColorFrag[Row])
       do begin
          with TabColorFrag[Row,Col]
          do begin
             case RqCannel of
              'R' : ME := ME + TabColorFrag[Row,Col].R;
              'G' : ME := ME + TabColorFrag[Row,Col].G;
              'B' : ME := ME + TabColorFrag[Row,Col].B;
              'L' : begin
                      //   LIGHT
                      WE := Sqrt(R * R + G * G + B * B) / LC;
                      ME := ME + WE;
                    end;
               else ME := 0;
             end;
          end;
          Num := Num + 1;
       end;
    end;
    //    
    Result := ME / Num;
end;
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------


// ========================================================================
//               END OF IMPLEMENTATION
// ========================================================================
end.
